# Troubleshooting Guide

## Login Issues

### 401 Unauthorized Error

If you're getting a 401 error when trying to login, follow these steps:

#### Step 1: Create/Reset Admin Account

1. **Upload `create_admin.php` to your server**
2. **Access it via browser**: `https://yourdomain.com/create_admin.php`
3. **It will create/reset the admin account with:**
   - Email: `admin@example.com`
   - Password: `admin123`
4. **DELETE the file after use** for security!

#### Step 2: Verify Database Connection

Check `config/db.php` has correct credentials:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'employee_attendance');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

#### Step 3: Check Database

Verify admin exists in database:
```sql
SELECT * FROM admins;
```

If no admin exists, run `create_admin.php` or manually insert:
```sql
INSERT INTO admins (email, password_hash) VALUES 
('admin@example.com', '$2y$10$N9qo8uLOickgx2ZMRZoMyeIjZAgcfl7p92ldGxad68LJZdL17lhWy');
```

#### Step 4: Test Password Hash

Create a test file `test_hash.php`:
```php
<?php
require_once 'config/db.php';

$email = 'admin@example.com';
$password = 'admin123';

$pdo = getDB();
$stmt = $pdo->prepare("SELECT password_hash FROM admins WHERE email = ?");
$stmt->execute([$email]);
$admin = $stmt->fetch();

if ($admin) {
    if (password_verify($password, $admin['password_hash'])) {
        echo "✅ Password hash is correct!";
    } else {
        echo "❌ Password hash is incorrect. Run create_admin.php";
    }
} else {
    echo "❌ Admin not found. Run create_admin.php";
}
?>
```

**Delete this file after testing!**

### Common Issues

#### Issue: "Database connection failed"
- **Solution**: Check `config/db.php` credentials
- Verify database exists
- Check MySQL user has proper permissions

#### Issue: "Invalid email or password" but credentials are correct
- **Solution**: Run `create_admin.php` to reset password hash
- The hash in database might be incorrect

#### Issue: Session not working
- **Solution**: 
  - Check PHP sessions are enabled
  - Verify session directory is writable
  - Check `.htaccess` is working
  - Clear browser cookies

#### Issue: 500 Internal Server Error
- **Solution**:
  - Check PHP error logs
  - Verify all files are uploaded correctly
  - Check file permissions (644 for files, 755 for folders)

### Quick Fix Script

If login is not working, use this one-time script:

1. Upload `create_admin.php`
2. Access it in browser
3. Delete the file immediately after

This will create/reset your admin account with:
- Email: `admin@example.com`  
- Password: `admin123`

Then login and change the password immediately!
